#!/bin/sh

NEW_NAME="$1"

if [ ! "$#" = "1" ]; then
    echo "Illegal number of parameters!!"
    echo "Usage: $0 update-amd-pro-nonpro-DRIVER_VERSION"
    echo "e.g. $0 update-amd-pro-nonpro-17.10-401251-99dfd335"
    exit 0
fi

NAMING=`echo $NEW_NAME | grep "update-amd-pro-nonpro" | wc -l`
if [ "$NAMING" = "0" ]; then
    echo "Please use correct naming scheme: update-amd-pro-nonpro-DRIVER_VERSION"
    echo "e.g. $0 update-amd-pro-nonpro-17.10-401251-99dfd335"
    exit 0
fi

OLD_NAME=`grep -r -e "Package:" ./debian/control | cut -d ":" -f 2 | tr -d ' '`
echo "Old Package Name: $OLD_NAME"
echo "New Package Name: $NEW_NAME"

mkdir ./tmp

for i in ./usr/share/$OLD_NAME/$OLD_NAME* ;
do
    sed -e "s|$OLD_NAME|$NEW_NAME|g" $i > ./tmp/$(basename $i)
    rm $i
done

for i in ./debian/* ;
do
    if [ -f $i ]; then
        if [ "$(basename $i)" = "control" ] || [ "$(basename $i)" = "copyright" ]; then
            sed -e "s|: $OLD_NAME|: $NEW_NAME|g" $i > ./tmp/$(basename $i)
        else
            sed -e "s|$OLD_NAME|$NEW_NAME|g" $i > ./tmp/$(basename $i)
        fi
    fi
done

mv ./usr/share/$OLD_NAME ./usr/share/$NEW_NAME
mv ./tmp/$OLD_NAME.sh ./usr/share/$NEW_NAME/$NEW_NAME.sh
mv ./tmp/$OLD_NAME.desktop ./usr/share/$NEW_NAME/$NEW_NAME.desktop
mv ./tmp/* ./debian/
rm -r ./tmp
