/*****************************************************************************
 *
 * grail - Gesture Recognition And Instantiation Library
 *
 * Copyright (C) 2010 Canonical Ltd.
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation, either version 3 of the License, or (at your
 * option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors:
 *      Henrik Rydberg <rydberg@bitmath.org>
 *
 ****************************************************************************/

#include <grail-touch.h>
#include <string.h>
#include <stdio.h>
#include <unistd.h>
#include <fcntl.h>

static void tp_event(struct touch_dev *dev,
		     const struct input_event *ev)
{
	fprintf(stderr, "event %d 0x%x %d\n", ev->type, ev->code, ev->value);
}

static void tp_sync(struct touch_dev *dev,
		    const struct input_event *syn)
{
	struct touch_frame *frame = &dev->frame;
	int i, j;
	for (i = 0; i < frame->nactive; i++) {
		struct touch *t = frame->active[i];
		fprintf(stderr, "touch %d\n", i);
		fprintf(stderr, "  slot:         %d\n", t->slot);
		fprintf(stderr, "  id:           %d\n", t->id);
		fprintf(stderr, "  tool_type:    %d\n", t->tool_type);
		fprintf(stderr, "  x:            %d\n", t->x);
		fprintf(stderr, "  y:            %d\n", t->y);
		fprintf(stderr, "  touch_major:  %d\n", t->touch_major);
		fprintf(stderr, "  touch_minor:  %d\n", t->touch_minor);
		fprintf(stderr, "  width_major:  %d\n", t->width_major);
		fprintf(stderr, "  width_minor:  %d\n", t->width_minor);
		fprintf(stderr, "  angle:        %f\n",
			touch_angle(dev, t->orientation));
		fprintf(stderr, "  pressure:     %f\n",
			touch_pressure(dev, t->pressure));
	}
	fprintf(stderr, "sync %d %lld %d %d\n",
		frame->nactive, frame->time, frame->ncreate, frame->ndestroy);
}

static void loop_device(struct touch_dev *dev, int fd)
{
	dev->event = tp_event;
	dev->sync = tp_sync;
	while (!touch_dev_idle(dev, fd, 5000))
		touch_dev_pull(dev, fd);
}

int main(int argc, char *argv[])
{
	struct touch_dev dev;
	int fd;
	if (argc < 2) {
		fprintf(stderr, "Usage: %s <device>\n", argv[0]);
		return -1;
	}
	fd = open(argv[1], O_RDONLY | O_NONBLOCK);
	if (fd < 0) {
		fprintf(stderr, "error: could not open device\n");
		return -1;
	}
	if (ioctl(fd, EVIOCGRAB, 1)) {
		fprintf(stderr, "error: could not grab the device\n");
		return -1;
	}
	if (touch_dev_open(&dev, fd)) {
		fprintf(stderr, "error: could not open touch device\n");
		return -1;
	}
	loop_device(&dev, fd);
	touch_dev_close(&dev, fd);
	ioctl(fd, EVIOCGRAB, 0);
	close(fd);
	return 0;
}
