#ifndef __WS_COMMON_H__
#define __WS_COMMON_H__

#include <string.h>
#include <gtk/gtk.h>
#include <glade/glade.h>
#include <gconf/gconf-client.h>
#include <gconf/gconf-value.h>

//******************************
// Define
//******************************
enum {
	COL_PIXBUF1,
	COL_NAME,
	N_COLUMNS
};

#define WS_PICT_BASE_PATH			"/usr/share/backgrounds"
#define WS_CNFG_BASE_PATH			"/usr/share/wallpaper_select"
#define WS_SOURCE_CFG_FILE			WS_CNFG_BASE_PATH "/wp.config"
#define WS_SOURCE_ATSTART_PATH		"/.config/autostart"
#define WS_SOURCE_ATSTART_FILE		"wallpaper-select.desktop"
#define WS_SOURCE_DESKTOP_FILE		WS_CNFG_BASE_PATH "/wallpaper-select.desktop"

#define WS_BASE_KEY_WP				"/desktop/gnome/background"
#define WS_SOURCE_SCHEME_WP_FILE	WS_BASE_KEY_WP "/picture_filename"
#define WS_SOURCE_SCHEME_WP_OPT		WS_BASE_KEY_WP "/picture_options"
#define WS_WP_OPT_VALUE				"stretched"

#define WS_SKIN_MAX					10
#define WS_STRLEN					128
#define WS_PICT_WIDTH				140
#define WS_PICT_HEIGHT				140
#define WS_ICON_WIDTH				(WS_PICT_WIDTH+20)

//******************************
// Variables
//******************************
GtkWidget *dialog;
GtkWidget *icon_view;
GladeXML *gxml;

//******************************
// Prottype
//******************************
void gconf_manager_init (void);
gboolean set_gconf_sub_string (gchar* key, const gchar *str);
gchar *get_gconf_sub_string (gchar* key);

#endif  /* __WS_COMMON_H__ */