# -*- coding: utf-8 -*-
### BEGIN LICENSE
# This file is in the public domain
### END LICENSE

# THIS IS Winboot CONFIGURATION FILE
# YOU CAN PUT THERE SOME GLOBAL VALUE
# Do not touch until you know what you're doing.
# you're warned :)

# where your project will head for your data (for instance, images and ui files)
# by default, this is ../data, relative your trunk layout
__winboot_data_directory__ = '../data/'
__license__ = ''


import os

class project_path_not_found(Exception):
    pass

def get_data_file(*path_segments):
    """Get the full path to a data file.

    Returns the path to a file underneath the data directory (as defined by
    `get_data_path`). Equivalent to os.path.join(get_data_path(),
    *path_segments).
    """
    return os.path.join(getdatapath(), *path_segments)

def getdatapath():
    """Retrieve winboot data path

    This path is by default <winboot_lib_path>/../data/ in trunk
    and /usr/share/winboot in an installed version but this path
    is specified at installation time.
    """

    # get pathname absolute or relative
    if __winboot_data_directory__.startswith('/'):
        pathname = __winboot_data_directory__
    else:
        pathname = os.path.dirname(__file__) + '/' + __winboot_data_directory__

    abs_data_path = os.path.abspath(pathname)
    if os.path.exists(abs_data_path):
        return abs_data_path
    else:
        raise project_path_not_found

