/*
 * Decompiled with CFR 0.152.
 */
package writer2latex.latex;

import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import writer2latex.latex.ConverterHelper;
import writer2latex.latex.ConverterPalette;
import writer2latex.latex.LaTeXDocumentPortion;
import writer2latex.latex.util.BeforeAfter;
import writer2latex.latex.util.Context;
import writer2latex.latex.util.StyleMap;
import writer2latex.office.ListStyle;
import writer2latex.office.OfficeReader;
import writer2latex.util.Config;
import writer2latex.util.Misc;

public class BlockConverter
extends ConverterHelper {
    public BlockConverter(OfficeReader ofr, Config config, ConverterPalette palette) {
        super(ofr, config, palette);
    }

    public void appendDeclarations(LaTeXDocumentPortion pack, LaTeXDocumentPortion decl) {
    }

    public void traverseBlockText(Element node, LaTeXDocumentPortion ldp, Context oc) {
        Context ic = (Context)oc.clone();
        StyleMap blockMap = this.config.getParBlockStyleMap();
        String sBlockName = null;
        if (node.hasChildNodes()) {
            NodeList list = node.getChildNodes();
            int nLen = list.getLength();
            int i = 0;
            while (i < nLen) {
                Node childNode = list.item(i);
                if (childNode.getNodeType() == 1) {
                    Element child = (Element)childNode;
                    String sTagName = child.getTagName();
                    if (!ic.isInTable()) {
                        if (sTagName.equals("text:p")) {
                            String sStyleName = this.ofr.getParStyles().getDisplayName(child.getAttribute("text:style-name"));
                            if (sBlockName != null && !blockMap.isNext(sBlockName, sStyleName)) {
                                String sAfter = blockMap.getAfter(sBlockName);
                                if (sAfter.length() > 0) {
                                    ldp.append(sAfter).nl();
                                }
                                sBlockName = null;
                                ic.setVerbatim(false);
                            }
                            if (sBlockName == null && blockMap.contains(sStyleName)) {
                                sBlockName = sStyleName;
                                String sBefore = blockMap.getBefore(sBlockName);
                                if (sBefore.length() > 0) {
                                    ldp.append(sBefore).nl();
                                }
                                ic.setVerbatim(blockMap.getVerbatim(sStyleName));
                            }
                        } else if (sBlockName != null) {
                            String sAfter = blockMap.getAfter(sBlockName);
                            if (sAfter.length() > 0) {
                                ldp.append(sAfter).nl();
                            }
                            sBlockName = null;
                            ic.setVerbatim(false);
                        }
                    }
                    this.palette.getFieldCv().flushReferenceMarks(ldp, ic);
                    this.palette.getIndexCv().flushIndexMarks(ldp, ic);
                    this.palette.getInfo().addDebugInfo(child, ldp);
                    if (sTagName.equals("text:p")) {
                        String sSequence = this.ofr.getSequenceName(child);
                        if (this.ofr.isFigureSequenceName(sSequence)) {
                            this.palette.getDrawCv().handleCaption(child, ldp, ic);
                        } else if (this.ofr.isTableSequenceName(sSequence)) {
                            if (i + 1 < nLen && Misc.isElement(list.item(i + 1), "table:table")) {
                                this.palette.getTableCv().handleTable((Element)list.item(++i), child, true, ldp, ic);
                            } else {
                                this.palette.getTableCv().handleCaption(child, ldp, ic);
                            }
                        } else {
                            this.palette.getParCv().handleParagraph(child, ldp, ic, i == nLen - 1);
                        }
                    } else if (sTagName.equals("text:h")) {
                        this.palette.getHeadingCv().handleHeading(child, ldp, ic);
                    } else if (sTagName.equals("text:list")) {
                        this.handleList(child, ldp, ic);
                    } else if (sTagName.equals("text:unordered-list")) {
                        this.handleList(child, ldp, ic);
                    } else if (sTagName.equals("text:ordered-list")) {
                        this.handleList(child, ldp, ic);
                    } else if (sTagName.equals("table:table")) {
                        if (i + 1 < nLen && Misc.isElement(list.item(i + 1), "text:p") && this.ofr.isTableSequenceName(this.ofr.getSequenceName((Element)list.item(i + 1)))) {
                            this.palette.getTableCv().handleTable(child, (Element)list.item(++i), false, ldp, oc);
                        } else {
                            this.palette.getTableCv().handleTable(child, null, false, ldp, oc);
                        }
                    } else if (sTagName.equals("table:sub-table")) {
                        this.palette.getTableCv().handleTable(child, null, true, ldp, ic);
                    } else if (sTagName.equals("text:section")) {
                        this.palette.getSectionCv().handleSection(child, ldp, ic);
                    } else if (sTagName.startsWith("draw:")) {
                        this.palette.getDrawCv().handleDrawElement(child, ldp, ic);
                    } else if (sTagName.equals("text:table-of-content")) {
                        this.palette.getIndexCv().handleTOC(child, ldp, ic);
                    } else if (sTagName.equals("text:illustration-index")) {
                        this.palette.getIndexCv().handleLOF(child, ldp, ic);
                    } else if (sTagName.equals("text:table-index")) {
                        this.palette.getIndexCv().handleLOT(child, ldp, ic);
                    } else if (sTagName.equals("text:object-index")) {
                        this.palette.getIndexCv().handleObjectIndex(child, ldp, ic);
                    } else if (sTagName.equals("text:user-index")) {
                        this.palette.getIndexCv().handleUserIndex(child, ldp, ic);
                    } else if (sTagName.equals("text:alphabetical-index")) {
                        this.palette.getIndexCv().handleAlphabeticalIndex(child, ldp, ic);
                    } else if (sTagName.equals("text:bibliography")) {
                        this.palette.getIndexCv().handleBibliography(child, ldp, ic);
                    } else if (sTagName.equals("text:sequence-decls")) {
                        this.palette.getFieldCv().handleSequenceDecls(child);
                    }
                }
                ++i;
            }
        }
        if (!oc.isInTable() && sBlockName != null) {
            String sAfter = blockMap.getAfter(sBlockName);
            if (sAfter.length() > 0) {
                ldp.append(sAfter).nl();
            }
            sBlockName = null;
        }
        this.palette.getFieldCv().flushReferenceMarks(ldp, ic);
        this.palette.getIndexCv().flushIndexMarks(ldp, ic);
    }

    public void handleList(Element node, LaTeXDocumentPortion ldp, Context oc) {
        ListStyle style;
        boolean bOrdered;
        Context ic = (Context)oc.clone();
        ic.incListLevel();
        if (ic.getListStyleName() == null) {
            ic.setListStyleName(node.getAttribute("text:style-name"));
        }
        boolean bl = bOrdered = (style = this.ofr.getListStyle(ic.getListStyleName())) != null && style.isNumber(ic.getListLevel());
        if (ic.isIgnoreLists() || this.listContainsHeadings(node)) {
            ic.setIgnoreLists(true);
            this.traverseList(node, ldp, ic);
            return;
        }
        BeforeAfter ba = new BeforeAfter();
        this.palette.getListSc().applyListStyle(ic.getListStyleName(), ic.getListLevel(), bOrdered, "true".equals(node.getAttribute("text:continue-numbering")), ba);
        if (ba.getBefore().length() > 0) {
            ldp.append(ba.getBefore()).nl();
        }
        this.traverseList(node, ldp, ic);
        if (ba.getAfter().length() > 0) {
            ldp.append(ba.getAfter()).nl();
        }
    }

    private void traverseList(Element node, LaTeXDocumentPortion ldp, Context oc) {
        if (node.hasChildNodes()) {
            NodeList list = node.getChildNodes();
            int nLen = list.getLength();
            int i = 0;
            while (i < nLen) {
                Node child = list.item(i);
                if (child.getNodeType() == 1) {
                    String nodeName = child.getNodeName();
                    this.palette.getInfo().addDebugInfo((Element)child, ldp);
                    if (nodeName.equals("text:list-item")) {
                        this.handleListItem((Element)child, ldp, oc);
                    }
                    if (nodeName.equals("text:list-header")) {
                        this.handleListItem((Element)child, ldp, oc);
                    }
                }
                ++i;
            }
        }
    }

    private void handleListItem(Element node, LaTeXDocumentPortion ldp, Context oc) {
        if (oc.isIgnoreLists()) {
            this.traverseBlockText(node, ldp, oc);
            return;
        }
        BeforeAfter ba = new BeforeAfter();
        this.palette.getListSc().applyListItemStyle(oc.getListStyleName(), oc.getListLevel(), node.getNodeName().equals("text:list-header"), "true".equals(node.getAttribute("text:restart-numbering")), Misc.getPosInteger(node.getAttribute("text:start-value"), 1) - 1, ba);
        if (ba.getBefore().length() > 0) {
            ldp.append(ba.getBefore());
            if (this.config.formatting() >= 3) {
                ldp.nl();
            }
        }
        this.traverseBlockText(node, ldp, oc);
        if (ba.getAfter().length() > 0) {
            ldp.append(ba.getAfter()).nl();
        }
    }

    private boolean listContainsHeadings(Node node) {
        if (node.hasChildNodes()) {
            NodeList nList = node.getChildNodes();
            int len = nList.getLength();
            int i = 0;
            while (i < len) {
                Node child = nList.item(i);
                if (child.getNodeType() == 1) {
                    String nodeName = child.getNodeName();
                    if (nodeName.equals("text:list-item") && this.listItemContainsHeadings(child)) {
                        return true;
                    }
                    if (nodeName.equals("text:list-header") && this.listItemContainsHeadings(child)) {
                        return true;
                    }
                }
                ++i;
            }
        }
        return false;
    }

    private boolean listItemContainsHeadings(Node node) {
        if (node.hasChildNodes()) {
            NodeList nList = node.getChildNodes();
            int len = nList.getLength();
            int i = 0;
            while (i < len) {
                Node child = nList.item(i);
                if (child.getNodeType() == 1) {
                    String nodeName = child.getNodeName();
                    if (nodeName.equals("text:h")) {
                        return true;
                    }
                    if (nodeName.equals("text:list") && this.listContainsHeadings(child)) {
                        return true;
                    }
                    if (nodeName.equals("text:ordered-list") && this.listContainsHeadings(child)) {
                        return true;
                    }
                    if (nodeName.equals("text:unordered-list") && this.listContainsHeadings(child)) {
                        return true;
                    }
                }
                ++i;
            }
        }
        return false;
    }
}

