/*
 * Decompiled with CFR 0.152.
 */
package writer2latex.latex;

import java.util.LinkedList;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import writer2latex.latex.ConverterHelper;
import writer2latex.latex.ConverterPalette;
import writer2latex.latex.LaTeXDocumentPortion;
import writer2latex.latex.ListStyleConverter;
import writer2latex.latex.util.BeforeAfter;
import writer2latex.latex.util.Context;
import writer2latex.office.OfficeReader;
import writer2latex.office.PropertySet;
import writer2latex.office.StyleWithProperties;
import writer2latex.util.Config;
import writer2latex.util.ExportNameCollection;
import writer2latex.util.Misc;

public class NoteConverter
extends ConverterHelper {
    private ExportNameCollection footnotenames = new ExportNameCollection(true);
    private ExportNameCollection endnotenames = new ExportNameCollection(true);
    private boolean bContainsEndnotes = false;
    private boolean bContainsFootnotes = false;
    private LinkedList postponedFootnotes = new LinkedList();

    public NoteConverter(OfficeReader ofr, Config config, ConverterPalette palette) {
        super(ofr, config, palette);
    }

    public void appendDeclarations(LaTeXDocumentPortion pack, LaTeXDocumentPortion decl) {
        if (this.bContainsEndnotes) {
            pack.append("\\usepackage{endnotes}").nl();
        }
        if (this.bContainsFootnotes) {
            this.convertFootnotesConfiguration(decl);
        }
        if (this.bContainsEndnotes) {
            this.convertEndnotesConfiguration(decl);
        }
    }

    public void handleFootnote(Element node, LaTeXDocumentPortion ldp, Context oc) {
        Context ic = (Context)oc.clone();
        ic.setInFootnote(true);
        String sId = node.getAttribute("text:id");
        Element fntbody = Misc.getChildByTagName(node, "text:footnote-body");
        if (fntbody == null) {
            fntbody = Misc.getChildByTagName(node, "text:note-body");
        }
        if (fntbody != null) {
            this.bContainsFootnotes = true;
            if (ic.isNoFootnotes()) {
                ldp.append("\\footnotemark{}");
                this.postponedFootnotes.add(fntbody);
            } else {
                ldp.append("\\footnote");
                ldp.append("{");
                if (sId != null && this.ofr.hasFootnoteRefTo(sId)) {
                    ldp.append("\\label{fnt:" + this.footnotenames.getExportName(sId) + "}");
                }
                this.traverseNoteBody(fntbody, ldp, ic);
                ldp.append("}");
            }
        }
    }

    public void flushFootnotes(LaTeXDocumentPortion ldp, Context oc) {
        if (oc.isNoFootnotes()) {
            return;
        }
        Context ic = (Context)oc.clone();
        ic.setInFootnote(true);
        int n = this.postponedFootnotes.size();
        if (n == 1) {
            ldp.append("\\footnotetext{");
            this.traverseNoteBody((Element)this.postponedFootnotes.get(0), ldp, ic);
            ldp.append("}").nl();
            this.postponedFootnotes.clear();
        } else if (n > 1) {
            ldp.append("\\addtocounter{footnote}{-" + n + "}").nl();
            int i = 0;
            while (i < n) {
                ldp.append("\\stepcounter{footnote}\\footnotetext{");
                this.traverseNoteBody((Element)this.postponedFootnotes.get(i), ldp, ic);
                ldp.append("}").nl();
                ++i;
            }
            this.postponedFootnotes.clear();
        }
    }

    public void handleEndnote(Element node, LaTeXDocumentPortion ldp, Context oc) {
        Context ic = (Context)oc.clone();
        ic.setInFootnote(true);
        String sId = node.getAttribute("text:id");
        Element entbody = Misc.getChildByTagName(node, "text:endnote-body");
        if (entbody == null) {
            entbody = Misc.getChildByTagName(node, "text:note-body");
        }
        if (entbody != null) {
            if (ic.isNoFootnotes() && !this.config.useEndnotes()) {
                ldp.append("\\footnotemark()");
                this.postponedFootnotes.add(entbody);
            } else {
                if (this.config.useEndnotes()) {
                    ldp.append("\\endnote");
                    this.bContainsEndnotes = true;
                } else {
                    ldp.append("\\footnote");
                    this.bContainsFootnotes = true;
                }
                ldp.append("{");
                if (sId != null && this.ofr.hasEndnoteRefTo(sId)) {
                    ldp.append("\\label{ent:" + this.endnotenames.getExportName(sId) + "}");
                }
                this.traverseNoteBody(entbody, ldp, ic);
                ldp.append("}");
            }
        }
    }

    public void insertEndnotes(LaTeXDocumentPortion ldp) {
        if (this.bContainsEndnotes) {
            ldp.append("\\clearpage").nl().append("\\theendnotes").nl();
        }
    }

    public void handleNoteRef(Element node, LaTeXDocumentPortion ldp, Context oc) {
        String sClass = node.getAttribute("text:note-class");
        if (sClass.equals("footnote")) {
            this.handleFootnoteRef(node, ldp, oc);
        } else if (sClass.equals("endnote")) {
            this.handleEndnoteRef(node, ldp, oc);
        }
    }

    public void handleFootnoteRef(Element node, LaTeXDocumentPortion ldp, Context oc) {
        String sFormat = node.getAttribute("text:reference-format");
        String sName = node.getAttribute("text:ref-name");
        if (("page".equals(sFormat) || "".equals(sFormat)) && sName != null) {
            ldp.append("\\pageref{fnt:" + this.footnotenames.getExportName(sName) + "}");
        } else if ("text".equals(sFormat) && sName != null) {
            ldp.append("\\ref{fnt:" + this.footnotenames.getExportName(sName) + "}");
        } else {
            this.palette.getInlineCv().traversePCDATA(node, ldp, oc);
        }
    }

    public void handleEndnoteRef(Element node, LaTeXDocumentPortion ldp, Context oc) {
        String sFormat = node.getAttribute("text:reference-format");
        String sName = node.getAttribute("text:ref-name");
        if (("page".equals(sFormat) || "".equals(sFormat)) && sName != null) {
            ldp.append("\\pageref{ent:" + this.endnotenames.getExportName(sName) + "}");
        } else if ("text".equals(sFormat) && sName != null) {
            ldp.append("\\ref{ent:" + this.endnotenames.getExportName(sName) + "}");
        } else {
            this.palette.getInlineCv().traversePCDATA(node, ldp, oc);
        }
    }

    public void addFootnoteName(String sName) {
        this.footnotenames.addName(sName);
    }

    public void addEndnoteName(String sName) {
        this.endnotenames.addName(sName);
    }

    private void traverseNoteBody(Element node, LaTeXDocumentPortion ldp, Context oc) {
        if (node.hasChildNodes()) {
            NodeList nList = node.getChildNodes();
            int len = nList.getLength();
            int i = 0;
            while (i < len) {
                Node childNode = nList.item(i);
                if (childNode.getNodeType() == 1) {
                    Element child = (Element)childNode;
                    String nodeName = child.getTagName();
                    this.palette.getInfo().addDebugInfo(child, ldp);
                    if (nodeName.equals("text:h")) {
                        this.palette.getHeadingCv().handleHeading(child, ldp, oc);
                    }
                    if (nodeName.equals("text:p")) {
                        this.palette.getInlineCv().traverseInlineText(child, ldp, oc, false);
                        if (i < len - 1) {
                            if (nList.item(i + 1).getNodeName().startsWith("text:")) {
                                ldp.append("\\par ");
                            } else {
                                ldp.nl();
                            }
                        }
                    } else if (nodeName.equals("text:list")) {
                        this.palette.getBlockCv().handleList(child, ldp, oc);
                    }
                    if (nodeName.equals("text:ordered-list")) {
                        this.palette.getBlockCv().handleList(child, ldp, oc);
                    }
                    if (nodeName.equals("text:unordered-list")) {
                        this.palette.getBlockCv().handleList(child, ldp, oc);
                    }
                }
                ++i;
            }
        }
    }

    private void convertFootnotesConfiguration(LaTeXDocumentPortion ldp) {
        this.convertFootEndnotesConfiguration(this.ofr.getFootnotesConfiguration(), "foot", ldp);
    }

    private void convertEndnotesConfiguration(LaTeXDocumentPortion ldp) {
        this.convertFootEndnotesConfiguration(this.ofr.getEndnotesConfiguration(), "end", ldp);
    }

    private void convertFootEndnotesConfiguration(PropertySet notes, String sType, LaTeXDocumentPortion ldp) {
        int nStartValue;
        String sTypeShort;
        if (this.config.formatting() < 2) {
            return;
        }
        String string = sTypeShort = sType.equals("foot") ? "fn" : "en";
        if (notes == null) {
            return;
        }
        ldp.append("% ").append(sType).append("notes configuration").nl().append("\\makeatletter").nl();
        String sFormat = notes.getProperty("style:num-format");
        if (sFormat != null) {
            ldp.append("\\renewcommand\\the").append(sType).append("note{").append(ListStyleConverter.numFormat(sFormat)).append("{").append(sType).append("note}}").nl();
        }
        if ("chapter".equals(notes.getProperty("text:start-numbering-at"))) {
            ldp.append("\\@addtoreset{").append(sType).append("note}{section}").nl();
        }
        if ((nStartValue = Misc.getPosInteger(notes.getProperty("text:start-value"), 0)) != 0) {
            ldp.append("\\setcounter{").append(sType).append("note}{" + nStartValue + "}").nl();
        }
        if (this.config.formatting() >= 3) {
            String sCitBodyStyle = notes.getProperty("text:citation-body-style-name");
            if (sCitBodyStyle != null && this.ofr.getTextStyle(sCitBodyStyle) != null) {
                BeforeAfter baText = new BeforeAfter();
                this.palette.getCharSc().applyTextStyle(sCitBodyStyle, baText, new Context());
                ldp.append("\\renewcommand\\@make").append(sTypeShort).append("mark{\\mbox{").append(baText.getBefore()).append("\\@the").append(sTypeShort).append("mark").append(baText.getAfter()).append("}}").nl();
            }
            String sCitStyle = notes.getProperty("text:citation-style-name");
            String sStyleName = notes.getProperty("text:default-style-name");
            if (sStyleName != null) {
                BeforeAfter baText = new BeforeAfter();
                this.palette.getCharSc().applyTextStyle(sCitStyle, baText, new Context());
                StyleWithProperties style = this.ofr.getParStyle(sStyleName);
                if (style != null) {
                    BeforeAfter baPar = new BeforeAfter();
                    this.palette.getCharSc().applyHardCharFormatting(style, baPar);
                    ldp.append("\\renewcommand\\@make").append(sTypeShort).append("text[1]{\\noindent").append(baText.getBefore()).append("\\@the").append(sTypeShort).append("mark\\ ").append(baText.getAfter()).append(baPar.getBefore()).append("#1").append(baPar.getAfter());
                    ldp.append("}").nl();
                }
            }
        }
        ldp.append("\\makeatother").nl();
    }
}

