*** Modules/posixmodule.c.old	Fri Oct 25 09:40:31 1996
--- Modules/posixmodule.c	Mon Apr 21 13:14:12 1997
***************
*** 1130,1133 ****
--- 1130,1205 ----
  #endif /* HAVE_SETUID */
  
+ #ifdef HAVE_SETEUID
+ static object *
+ posix_seteuid (self, args)
+      object * self;
+      object * args;
+ {
+   int euid;
+   if (!newgetargs (args, "i", &euid)) {
+     return NULL;
+   } else if (seteuid (euid) < 0) {
+     return posix_error();
+   } else {
+     INCREF (None);
+     return None;
+   }
+ }
+ #endif /* HAVE_SETEUID */
+ 
+ #ifdef HAVE_SETEGID
+ static object *
+ posix_setegid (self, args)
+      object * self;
+      object * args;
+ {
+   int egid;
+   if (!newgetargs (args, "i", &egid)) {
+     return NULL;
+   } else if (setegid (egid) < 0) {
+     return posix_error();
+   } else {
+     INCREF (None);
+     return None;
+   }
+ }
+ #endif /* HAVE_SETEGID */
+ 
+ #ifdef HAVE_SETREUID
+ static object *
+ posix_setreuid (self, args)
+      object * self;
+      object * args;
+ {
+   int ruid, euid;
+   if (!newgetargs (args, "ii", &ruid, &euid)) {
+     return NULL;
+   } else if (setreuid (ruid, euid) < 0) {
+     return posix_error();
+   } else {
+     INCREF (None);
+     return None;
+   }
+ }
+ #endif /* HAVE_SETREUID */
+ 
+ #ifdef HAVE_SETREGID
+ static object *
+ posix_setregid (self, args)
+      object * self;
+      object *args;
+ {
+   int rgid, egid;
+   if (!newgetargs (args, "ii", &rgid, &egid)) {
+     return NULL;
+   } else if (setregid (rgid, egid) < 0) {
+     return posix_error();
+   } else {
+     INCREF (None);
+     return None;
+   }
+ }
+ #endif /* HAVE_SETREGID */
+ 
  #ifdef HAVE_SETGID
  static object *
***************
*** 1707,1710 ****
--- 1779,1794 ----
  	{"setuid",	posix_setuid},
  #endif /* HAVE_SETUID */
+ #ifdef HAVE_SETEUID
+ 	{"seteuid",	posix_seteuid,	1},
+ #endif /* HAVE_SETEUID */
+ #ifdef HAVE_SETEGID
+ 	{"setegid",	posix_setegid,	1},
+ #endif /* HAVE_SETEGID */
+ #ifdef HAVE_SETREUID
+ 	{"setreuid",	posix_setreuid,	1},
+ #endif /* HAVE_SETREUID */
+ #ifdef HAVE_SETREGID
+ 	{"setregid",	posix_setreuid,	1},
+ #endif /* HAVE_SETREGID */
  #ifdef HAVE_SETGID
  	{"setgid",	posix_setgid},
