/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.codenorm;

import net.sf.saxon.codenorm.NormalizerData;
import net.sf.saxon.codenorm.UnicodeDataParser;
import net.sf.saxon.om.XMLChar;
import net.sf.saxon.trans.DynamicError;
import net.sf.saxon.trans.XPathException;

public class Normalizer {
    static final byte COMPATIBILITY_MASK = 1;
    static final byte COMPOSITION_MASK = 2;
    public static final byte D = 0;
    public static final byte C = 2;
    public static final byte KD = 1;
    public static final byte KC = 3;
    public static final byte NO_ACTION = 8;
    private byte form;
    private static NormalizerData data = null;

    public Normalizer(byte by) {
        this.form = by;
        if (data == null) {
            data = UnicodeDataParser.build();
        }
    }

    public Normalizer(CharSequence charSequence) throws XPathException {
        String string = ((Object)charSequence).toString().trim();
        int n = 2;
        if (string.length() == 0) {
            n = 8;
        } else if (string.equalsIgnoreCase("NFC")) {
            n = 2;
        } else if (string.equalsIgnoreCase("NFD")) {
            n = 0;
        } else if (string.equalsIgnoreCase("NFKC")) {
            n = 3;
        } else if (string.equalsIgnoreCase("NFKD")) {
            n = 1;
        } else {
            String string2 = "Normalization form " + string + " is not supported";
            throw new DynamicError(string2, "FOCH0003");
        }
        this.form = (byte)n;
        if (data == null) {
            data = UnicodeDataParser.build();
        }
    }

    private StringBuffer normalize(CharSequence charSequence, StringBuffer stringBuffer) {
        if (this.form == 8 || charSequence.length() == 0) {
            return new StringBuffer(((Object)charSequence).toString());
        }
        this.internalDecompose(charSequence, stringBuffer);
        if ((this.form & 2) != 0) {
            this.internalCompose(stringBuffer);
        }
        return stringBuffer;
    }

    public CharSequence normalize(CharSequence charSequence) {
        return this.normalize(charSequence, new StringBuffer(charSequence.length() + 8));
    }

    private void internalDecompose(CharSequence charSequence, StringBuffer stringBuffer) {
        StringBuffer stringBuffer2 = new StringBuffer(8);
        boolean bl = (this.form & 1) == 0;
        int n = 0;
        while (n < charSequence.length()) {
            int n2;
            stringBuffer2.setLength(0);
            int n3 = charSequence.charAt(n++);
            if (XMLChar.isHighSurrogate(n3)) {
                n2 = charSequence.charAt(n++);
                n3 = XMLChar.supplemental((char)n3, (char)n2);
            }
            data.getRecursiveDecomposition(bl, n3, stringBuffer2);
            int n4 = 0;
            while (n4 < stringBuffer2.length()) {
                int n5;
                char c;
                n2 = stringBuffer2.charAt(n4++);
                if (XMLChar.isHighSurrogate(n3)) {
                    c = stringBuffer2.charAt(n4++);
                    n2 = XMLChar.supplemental((char)n2, c);
                }
                c = data.getCanonicalClass(n2);
                if (c != '\u0000') {
                    for (n5 = stringBuffer.length(); n5 > 0; --n5) {
                        int n6 = stringBuffer.charAt(n5 - 1);
                        if (XMLChar.isSurrogate(n6)) {
                            char c2 = stringBuffer2.charAt(--n5 - 1);
                            n6 = XMLChar.supplemental(c2, (char)n6);
                        }
                        if (data.getCanonicalClass(n6) <= c) break;
                    }
                }
                if (n2 < 65536) {
                    stringBuffer.insert(n5, (char)n2);
                    continue;
                }
                String string = "" + XMLChar.highSurrogate(n2) + XMLChar.lowSurrogate(n2);
                stringBuffer.insert(n5, string);
            }
        }
    }

    private void internalCompose(StringBuffer stringBuffer) {
        int n;
        int n2 = 0;
        int n3 = stringBuffer.charAt(0);
        int n4 = 1;
        if (XMLChar.isHighSurrogate(n3)) {
            n3 = XMLChar.supplemental((char)n3, stringBuffer.charAt(1));
            ++n4;
        }
        if ((n = data.getCanonicalClass(n3)) != 0) {
            n = 256;
        }
        int n5 = stringBuffer.length();
        int n6 = n4;
        while (n6 < stringBuffer.length()) {
            int n7;
            if (XMLChar.isHighSurrogate(n7 = stringBuffer.charAt(n6++))) {
                n7 = XMLChar.supplemental((char)n7, stringBuffer.charAt(n6++));
            }
            int n8 = data.getCanonicalClass(n7);
            char c = data.getPairwiseComposition(n3, n7);
            if (c != '\uffff' && (n < n8 || n == 0)) {
                Normalizer.setCharAt(stringBuffer, n2, c);
                n3 = c;
                continue;
            }
            if (n8 == 0) {
                n2 = n4;
                n3 = n7;
            }
            n = n8;
            Normalizer.setCharAt(stringBuffer, n4, n7);
            if (stringBuffer.length() != n5) {
                n6 += stringBuffer.length() - n5;
                n5 = stringBuffer.length();
            }
            n4 += n7 < 65536 ? 1 : 2;
        }
        stringBuffer.setLength(n4);
    }

    private static void setCharAt(StringBuffer stringBuffer, int n, int n2) {
        if (n2 < 65536) {
            if (XMLChar.isHighSurrogate(stringBuffer.charAt(n))) {
                stringBuffer.setCharAt(n, (char)n2);
                stringBuffer.deleteCharAt(n + 1);
            } else {
                stringBuffer.setCharAt(n, (char)n2);
            }
        } else if (XMLChar.isHighSurrogate(stringBuffer.charAt(n))) {
            stringBuffer.setCharAt(n, XMLChar.highSurrogate(n2));
            stringBuffer.setCharAt(n + 1, XMLChar.lowSurrogate(n2));
        } else {
            stringBuffer.setCharAt(n, XMLChar.highSurrogate(n2));
            stringBuffer.insert(n + 1, XMLChar.lowSurrogate(n2));
        }
    }

    boolean getExcluded(char c) {
        return data.getExcluded(c);
    }

    String getRawDecompositionMapping(char c) {
        return data.getRawDecompositionMapping(c);
    }
}

